﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Net;

namespace Asteroid
  {
  /// <summary>
  /// Ein Element der des Winkelbytes
  /// </summary>
  /// ****************************************************************************************************
  /// * Datum: 14.06.2008 14:25
  /// * Computer: ATHLON3500VISTA
  /// * Benutzer: thomas
  /// *
  /// * Beschreibung: Ein Element der des Winkelbytes 
  /// ****************************************************************************************************
  struct AngleInformation
    {
    public byte AngleByte;
    public double InternAngles;
    public int InternX;
    public int InternY;
    public int ScreenX;
    public int ScreenY;
    }

  /// <summary>
  /// KI zu Astroid
  /// </summary>
  /// ****************************************************************************************************
  /// * Datum: 14.06.2008 14:27
  /// * Computer: ATHLON3500VISTA
  /// * Benutzer: thomas
  /// *
  /// * Beschreibung: KI zu Astroid 
  /// ****************************************************************************************************
  class PlayerKI
    {
    private int m_iSocket = 0;
    private IPAddress m_IPAdress = null;
    private string m_strUrl = string.Empty;
    private UdpClient m_UDPClient = null;
    private IPEndPoint m_IPEndPoint = null;
    private AngleInformation[] m_AngleTable = new AngleInformation[256];

    private bool m_RunOnce = true;
    /// <summary>
    /// Gets a value indicating whether [run once].
    /// </summary>
    /// <value><c>true</c> if [run once]; otherwise, <c>false</c>.</value>
    /// ****************************************************************************************************
    /// * Datum: 08.06.2008 13:30
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public bool RunOnce
      {
      get
        {
        return m_RunOnce;
        }
      }

    /// <summary>
    /// Konstruktor
    /// </summary>
    /// <param name="IP">The IP.</param>
    /// <param name="iSocket">The i socket.</param>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:21
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Konstruktor  
    /// ****************************************************************************************************
    public PlayerKI(IPAddress IP, int iSocket)
      {
      m_UDPClient = new UdpClient();
      m_iSocket = iSocket;
      m_IPAdress = IP;
      m_IPEndPoint = new IPEndPoint(m_IPAdress, m_iSocket);
      m_UDPClient.Connect(m_IPAdress, m_iSocket);

      CreateAngleTable();
      }

    /// <summary>
    /// Konstruktor
    /// </summary>
    /// <param name="strUrl">The STR URL.</param>
    /// <param name="iSocket">The i socket.</param>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:21
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Konstruktor 
    /// ****************************************************************************************************
    public PlayerKI(string strUrl, int iSocket)
      {
      m_UDPClient = new UdpClient();
      m_strUrl = strUrl;
      m_iSocket = iSocket;
      m_UDPClient.Connect(m_strUrl, m_iSocket);
      m_IPEndPoint = (IPEndPoint)m_UDPClient.Client.RemoteEndPoint;

      CreateAngleTable();
      }

    /// <summary>
    /// Winkelbytetabelle erstellen.
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 04.05.2008 15:28
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Winkelbytetabelle erstellen. 
    /// ****************************************************************************************************
    private void CreateAngleTable()
      {
      AngleByte angleByte = new AngleByte();

      for (int i = 0; i <= 255; i++)
        {
        m_AngleTable[i].AngleByte = (byte)i;
        m_AngleTable[i].InternAngles = i * 3 * (360.0 / 256);

        if (m_AngleTable[i].InternAngles >= 360 && m_AngleTable[i].InternAngles < 720)
          m_AngleTable[i].InternAngles -= 360;

        if (m_AngleTable[i].InternAngles >= 720)
          m_AngleTable[i].InternAngles -= 720;

        m_AngleTable[i].InternY = (int)Math.Round(Math.Sin(m_AngleTable[i].InternAngles / (180 / Math.PI)) * 1536);
        m_AngleTable[i].InternX = (int)Math.Round(Math.Cos(m_AngleTable[i].InternAngles / (180 / Math.PI)) * 1536);

        m_AngleTable[i].ScreenX = angleByte.X[i];
        m_AngleTable[i].ScreenY = angleByte.Y[i];

        //Console.WriteLine(String.Format("{0}: {1:f1}°, X: {2:f2}, Y: {3:f2}, XS: {4}, YS: {5}", i, m_AngleTable[i].InternAngles, m_AngleTable[i].InternX, m_AngleTable[i].InternY, m_AngleTable[i].ScreenX, m_AngleTable[i].ScreenY));
        }
      }

    /// <summary>
    /// Creates the code.
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 12.05.2008 12:54
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    //private void CreateCode()
    //  {
    //  System.IO.StreamReader stream = new System.IO.StreamReader(@".\data.dat");
    //  System.IO.StreamWriter streamout = new System.IO.StreamWriter(@".\AngleByte.cs");
    //  string strBuf = string.Empty;

    //  streamout.WriteLine("using System;");
    //  streamout.WriteLine("using System.Collections.Generic;");
    //  streamout.WriteLine("using System.Text;");
    //  streamout.WriteLine("using System.Net.Sockets;");
    //  streamout.WriteLine("using System.Net;");
    //  streamout.WriteLine();
    //  streamout.WriteLine();
    //  streamout.WriteLine("namespace Asteroid");
    //  streamout.WriteLine("{");
    //  streamout.WriteLine("class AngleByte");
    //  streamout.WriteLine("{");
    //  streamout.WriteLine("private int[] m_arriX = new int[256];");
    //  streamout.WriteLine("public int[] X\n{get\n{\nreturn m_arriX;\n}\n}");
    //  streamout.WriteLine("private int[] m_arriY = new int[256];");
    //  streamout.WriteLine("public int[] Y\n{get\n{\nreturn m_arriY;\n}\n}");      
    //  streamout.WriteLine("public AngleByte()");
    //  streamout.WriteLine("{");    


    //  for (int i = 0; i <= 255; i++)
    //    {
    //    strBuf = stream.ReadLine();
    //    string[] strArrBufIndex = strBuf.Split(';');

    //    streamout.WriteLine("m_arriX[{0}] = {1};", i, Convert.ToInt32(strArrBufIndex[0]));
    //    streamout.WriteLine("m_arriY[{0}] = {1};", i, Convert.ToInt32(strArrBufIndex[1]));

    //    //Console.WriteLine(String.Format("{0}: {1:f1}°, X: {2:f2}, Y: {3:f2}, XS: {4}, YS: {5}", i, m_AngleTable[i].InternAngles, m_AngleTable[i].InternX, m_AngleTable[i].InternY, m_AngleTable[i].ScreenX, m_AngleTable[i].ScreenY));
    //    }

    //  streamout.WriteLine("}");
    //  streamout.WriteLine("}");
    //  streamout.WriteLine("}");
    //  stream.Close();
    //  streamout.Close();
    //  }

    /// <summary>
    /// Spielernamen senden.
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 08.05.2008 22:54
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Spielernamen senden. 
    /// ****************************************************************************************************
    private void SendPlayerName()
      {
      byte[] Playername = new byte[38];

      Playername[0] = (byte)'c';
      Playername[1] = (byte)'t';
      Playername[2] = (byte)'n';
      Playername[3] = (byte)'a';
      Playername[4] = (byte)'m';
      Playername[5] = (byte)'e';
      Playername[6] = (byte)'Z';
      Playername[7] = (byte)'y';
      Playername[8] = (byte)'k';
      Playername[9] = (byte)'l';
      Playername[10] = (byte)'o';
      Playername[11] = (byte)'b';

      for (int i = 12; i < 38; i++)
        Playername[i] = 0;

      m_UDPClient.Send(Playername, Playername.Length * sizeof(byte));
      }

    /// <summary>
    /// Dekonstruktor
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:34
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Dekonstruktor 
    /// ****************************************************************************************************
    ~PlayerKI()
      {
      m_UDPClient.Close();
      }

    /// <summary>
    /// Spielt Asteriod
    /// </summary>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:23
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Spielt Asteriod 
    /// ****************************************************************************************************
    public void Run()
      {
      KeysPacket Keys = new KeysPacket();
      FramePacket Frame = new FramePacket();
      GameStatus[] arrGame = new GameStatus[2];
      Position OldPosition;
      StarShip Ship = new StarShip();
      bool bExit = false;
      int iMinDistance = 0x7fffffff;
      int iMinShotDistance = 0x7fffffff;
      int iMinTargetDistance2 = 0x7fffffff;
      int iMinDxTarget = 0;
      int iMinTargetDistance = 0x7fffffff;
      int iMinDyTarget = 0;
      int iMinDxShot = 0;
      int iMinDyShot = 0;
      int iDx = 0;
      int iDy = 0;
      int iDistance = 0;
      int iDistanceRef = 28 * 28;
      int i = 0;
      int iShotDistance1 = 0;
      int iShotDistance2 = 0;
      //double dTanTarget = 0;
      //double dTanShip = 0;
      int iTarget = 0;
      byte PrevFrame = 0;
      int iTimer = 0;
      byte AngleByte = 0;
      int iOldAngleX = 0;
      int iOldAngle2X = 0;
      int iOldAngle3X = 0;
      int iLastTurn = 0;
      int iLastTurn2 = 0;

      int iOldAngleY = 0;
      int iOldAngle2Y = 0;
      int iOldAngle3Y = 0;
      int iAngleInitCount = 0;
      int iLatenz = 0;
      ScreenObject Mastertarget = new ScreenObject();
      int iInfo = 0;

      for (i = 0; i < arrGame.Length; i++)
        arrGame[i] = new GameStatus();


      // Endlosschleife bis "ESC" gedrückt, "game over" oder "busy" vom Server gesendet werden
      do
        {
        ++iTimer;         // Zeit
        ++Keys.Ping; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
        SendPacket(ref Keys);

#if !DEBUG
        if (iTimer == 10)
          SendPlayerName();
#endif

        ReceivePacket(ref Frame);

        // Latenz Messung
        if (Frame.Frameno != ++PrevFrame || Frame.Ping != Keys.Ping)
          {
          iLatenz = Keys.Ping - Frame.Ping;
          Console.WriteLine(Properties.Resources.strLatenz, iLatenz, Frame.Frameno - PrevFrame, DateTime.Now.TimeOfDay);
          PrevFrame = Frame.Frameno;
          if (iLatenz > 200)
            iLatenz = 256 - iLatenz;
          else
            iLatenz--;
          }
        else
          iLatenz = 0;

        InterpretScreen(ref Frame, ref arrGame[1]);

        // Alle Tasten loslassen
        Keys.ClearKeys();

        iMinDistance = 0x7fffffff;
        iMinShotDistance = 0x7fffffff;
        iMinTargetDistance = 0x7fffffff;
        iMinTargetDistance2 = 0x7fffffff;
        iMinDxTarget = 0;
        iMinDyTarget = 0;
        iMinDxShot = 0;
        iMinDyShot = 0;

        if (arrGame[1].IsShipPresent)
          {
          // Winkelbyte snchronisieren
          if (iAngleInitCount < 2000)
            {
            for (int z = 3; z <= 255; z++)
              {
              if (arrGame[1].MyShip.ShipDirectionX == m_AngleTable[z].ScreenX
                && arrGame[1].MyShip.ShipDirectionY == m_AngleTable[z].ScreenY
                && iOldAngleX == m_AngleTable[z - 1].ScreenX
                && iOldAngleY == m_AngleTable[z - 1].ScreenY
                && iOldAngle2X == m_AngleTable[z - 2].ScreenX
                && iOldAngle2Y == m_AngleTable[z - 2].ScreenY
                && iOldAngle3X == m_AngleTable[z - 3].ScreenX
                && iOldAngle3Y == m_AngleTable[z - 3].ScreenY)
                {
                AngleByte = m_AngleTable[z].AngleByte;
                Console.WriteLine(Properties.Resources.strMastersync, AngleByte);
                iAngleInitCount = 2000;
                break;
                }
              }
            iAngleInitCount++;
            }
          else
            {
            AngleByte = SyncAngleByte(arrGame, AngleByte, iLastTurn2);
            }

          // Winkel für Synchronisierung merken
          iOldAngle3X = iOldAngle2X;
          iOldAngle3Y = iOldAngle2Y;
          iOldAngle2X = iOldAngleX;
          iOldAngle2Y = iOldAngleY;
          iOldAngleX = arrGame[1].MyShip.ShipDirectionX;
          iOldAngleY = arrGame[1].MyShip.ShipDirectionY;

          //#if DEBUG
          //          if (iInfo++ == 1)
          //            {
          //            //arrGame[0].WriteToFile(@"C:\Temp\Asteroid_Old.log");
          //            arrGame[1].WriteToFile(@"C:\Temp\Asteroid_Start.log");            
          //            }
          //#endif


          // nächsten Asteroid ermitteln
          for (i = 0; i < arrGame[1].CountAsteroids; ++i)
            {
            // Kurs ermitteln
            OldPosition = arrGame[0].Asteroids[i].CurrentPos;
            arrGame[1].Asteroids[i].CalculateCourse(ref OldPosition);

            // eigenen Kurs ermitteln
            OldPosition = arrGame[0].MyShip.CurrentPos;
            arrGame[1].MyShip.CalculateCourse(ref OldPosition);
            Ship = arrGame[1].MyShip;

            // Ziel berechnen
            iDistance = arrGame[1].Asteroids[i].CalculateShotPosition(ref  Ship, ref iLatenz, ref AngleByte, ref m_AngleTable);

            if (iDistance < iMinDistance)
              {
              iMinDistance = iDistance;
              iMinDxTarget = arrGame[1].Asteroids[i].CurrentShotPos.X;
              iMinDyTarget = arrGame[1].Asteroids[i].CurrentShotPos.Y;
              iMinTargetDistance = iMinDxTarget * iMinDxTarget + iMinDyTarget * iMinDyTarget;
              iMinTargetDistance2 = iMinTargetDistance;
              Mastertarget.CurrentShotPos.X = iMinDxTarget;
              Mastertarget.CurrentShotPos.Y = iMinDyTarget;
              Mastertarget.AngleByte = arrGame[1].Asteroids[i].AngleByte;
              }

            arrGame[1].MyShip = Ship;
            }

          // Wenn Ufo auf dem Bildschirm, dann ...
          if (arrGame[1].IsUfoPresent)
            {
            iMinTargetDistance2 = 0x7fffffff;
            // Kurs des Ufos ermitteln
            OldPosition = arrGame[0].Ufo.CurrentPos;

            arrGame[1].Ufo.CalculateCourse(ref OldPosition);

            // eigenen Kurs ermitteln
            OldPosition = arrGame[0].MyShip.CurrentPos;
            arrGame[1].MyShip.CalculateCourse(ref OldPosition);
            Ship = arrGame[1].MyShip;

            // Ziel berechnen
            iDistance = arrGame[1].Ufo.CalculateShotPosition(ref Ship, ref iLatenz, ref AngleByte, ref m_AngleTable);

            if (iDistance < iMinDistance)
              iMinDistance = iDistance;

            if (iDistance == iMinDistance || arrGame[1].Ufo.UfoSize > 0)
              {
              iMinDxTarget = arrGame[1].Asteroids[i].CurrentShotPos.X;
              iMinDyTarget = arrGame[1].Asteroids[i].CurrentShotPos.Y;
              iMinTargetDistance = iMinDxTarget * iMinDxTarget + iMinDyTarget * iMinDyTarget;
              }


            if (iMinTargetDistance2 > iMinTargetDistance)
              {
              iMinTargetDistance2 = iMinTargetDistance;
              Mastertarget.CurrentShotPos = arrGame[1].Ufo.CurrentShotPos;
              Mastertarget.AngleByte = arrGame[1].Ufo.AngleByte;
              }

            arrGame[1].MyShip = Ship;
            }

          // Wenn Schüsse auf dem Bildschirm, dann ...
          for (i = 0; i < arrGame[1].CountShots && arrGame[1].IsUfoPresent; ++i)
            {
            // Kurs des Schusses ermitteln
            OldPosition = arrGame[0].Shots[i].CurrentPos;
            arrGame[1].Shots[i].CalculateCourse(ref OldPosition);

            // Berechnen ob der Schuss dem eigenen Schiff nähert
            iDx = arrGame[1].Shots[i].CurrentPos.X - arrGame[1].MyShip.CurrentPos.X;
            iDy = arrGame[1].Shots[i].CurrentPos.Y - arrGame[1].MyShip.CurrentPos.Y;

            // dx normalisieren auf -512 ... 511
            while (iDx < -512)
              iDx += 1024;
            while (iDx > 511)
              iDx -= 1024;

            // dy normalisieren auf -384 ... 383

            while (iDy < -384)
              iDy += 768;
            while (iDy > 383)
              iDy -= 768;

            iDistance = iDx * iDx + iDy * iDy;

            iMinDxShot = arrGame[1].Shots[i].CurrentCourse.Pos[0].X - arrGame[1].MyShip.CurrentPos.X;
            iMinDyShot = arrGame[1].Shots[i].CurrentCourse.Pos[0].Y - arrGame[1].MyShip.CurrentPos.Y;

            iShotDistance1 = (int)Math.Round(Math.Sqrt(iMinDxShot * iMinDxShot + iMinDyShot * iMinDyShot));

            iMinDxShot = arrGame[1].Shots[i].CurrentCourse.Pos[2].X - arrGame[1].MyShip.CurrentPos.X;
            iMinDyShot = arrGame[1].Shots[i].CurrentCourse.Pos[2].Y - arrGame[1].MyShip.CurrentPos.Y;

            iShotDistance2 = (int)Math.Round(Math.Sqrt(iMinDxShot * iMinDxShot + iMinDyShot * iMinDyShot));

            // Prüfen ob der Schuss sich nähert
            if (iShotDistance2 < iShotDistance1)
              {
              arrGame[1].Shots[i].IsFrendly = false;
              iMinShotDistance = iDistance;
              }
            else
              arrGame[1].Shots[i].IsFrendly = true;
            }

          // Schiff in Richtung auf das nächstgelegene Objekt drehen
          // mathematisch wird hier das Kreuzprodukt aus den Vektoren

          if (arrGame[1].CountAsteroids == 0 && !arrGame[1].IsUfoPresent)
            Mastertarget = new ScreenObject();

          iTarget = m_AngleTable[AngleByte].InternX * Mastertarget.CurrentShotPos.Y - m_AngleTable[AngleByte].InternY * Mastertarget.CurrentShotPos.X;

          // Winkel des Ziels und des Schiffes berechnen
          //dTanTarget = Math.Atan2(Mastertarget.CurrentShotPos.Y, Mastertarget.CurrentShotPos.X) * (180 / Math.PI);
          //dTanShip = Math.Atan2(m_AngleTable[AngleByte].InternY, m_AngleTable[AngleByte].InternX) * (180 / Math.PI);

          // Schiff drehen
          //if (iTarget > 0)
          //  {
          //  Keys.Left(true);
          //  iLastTurn2 = iLastTurn;
          //  iLastTurn = 1;
          //  AngleByte++;
          //  }
          //else
          //  {
          //  if (iTarget < 0)
          //    {
          //    Keys.Right(true);
          //    iLastTurn2 = iLastTurn;
          //    iLastTurn = 2;
          //    AngleByte--;
          //    }
          //  else
          //    {
          //    iLastTurn2 = iLastTurn;
          //    iLastTurn = 0;
          //    }
          //  }

          if (arrGame[1].IsUfoPresent || arrGame[1].CountAsteroids > 0)
            {
            if (AngleByte - Mastertarget.AngleByte < 0)
              {
              Keys.Left(true);
              iLastTurn2 = iLastTurn;
              iLastTurn = 1;
              AngleByte++;
              }
            else
              {
              if (AngleByte - Mastertarget.AngleByte > 0)
                {
                Keys.Right(true);
                iLastTurn2 = iLastTurn;
                iLastTurn = 2;
                AngleByte--;
                }
              else
                {
                iLastTurn2 = iLastTurn;
                iLastTurn = 0;
                }
              }
            }
          else
            {
            iLastTurn2 = iLastTurn;
            iLastTurn = 0;
            }


          //double x = dTanShip - dTanTarget;

          //if (x < 0)
          //  x += 360;

          //// Schiff drehen
          //if (x > 180)
          //  {
          //  Keys.Left(true);
          //  iLastTurn2 = iLastTurn;
          //  iLastTurn = 1;
          //  AngleByte++;
          //  }
          //else
          //  {
          //  if (x < 180)
          //    {
          //    Keys.Right(true);
          //    iLastTurn2 = iLastTurn;
          //    iLastTurn = 2;
          //    AngleByte--;
          //    }
          //  else
          //    {
          //    iLastTurn2 = iLastTurn;
          //    iLastTurn = 0;
          //    }
          //  }


          ////Console.WriteLine(iTimer);
          //if (iMinDistance > 130 * 130 && iMinDistance < 325 * 325 && !arrGame[1].IsUfoPresent)
          // // && arrGame[1].CountAsteroids > 3)//iTimer > 7200)
          //  {
          //  int min = 300;
          //  for (int z = 0; z < arrGame[1].CountAsteroids; z++)
          //    {
          //    if (Math.Abs(AngleByte - arrGame[1].Asteroids[z].AngleByte) < min
          //      && arrGame[1].Asteroids[z].Distance < 290 * 290)
          //      {
          //      min = Math.Abs(AngleByte - Mastertarget.AngleByte);
          //      Mastertarget.AngleByte = arrGame[1].Asteroids[z].AngleByte;
          //      }
          //    }
          //  }

          if (!arrGame[1].IsUfoPresent)//iTimer > 7200)
            {
            int min = 300;
            for (int z = 0; z < arrGame[1].CountAsteroids; z++)
              {
              if (Math.Abs(AngleByte - arrGame[1].Asteroids[z].AngleByte) < min
                && arrGame[1].Asteroids[z].Distance < 290 * 290)
                {
                min = Math.Abs(AngleByte - Mastertarget.AngleByte);
                Mastertarget.AngleByte = arrGame[1].Asteroids[z].AngleByte;
                if (iMinDistance < 130 * 130)
                  break;
                }
              }
            }


          // Distanz zum nächsten Objekt prüfen
          if (iLatenz > 0 && iLatenz <= 3)
            iDistanceRef = 32 * 32;
          else
            iDistanceRef = 30 * 30;

          // Flucht, wenn Kollision unausweichlich
          if (iMinDistance < iDistanceRef || iMinShotDistance < iDistanceRef + 100)
            Keys.Hyperspace(true);

          if (iInfo < 0)
            iInfo++;

          if (Math.Abs(AngleByte - Mastertarget.AngleByte) == 0 && iInfo == 0 && arrGame[1].IsUfoPresent)
            {
            Keys.Fire(true);
            iInfo = -2;
            }

          for (i = 0; i < arrGame[1].CountAsteroids; i++)
            {
            if (Math.Abs(AngleByte - arrGame[1].Asteroids[i].AngleByte) == 0 && iInfo == 0
              && arrGame[1].Asteroids[i].CountShots++ < 2)
              {
              Keys.Fire(true);
              iInfo = -2;
              break;
              }

            if (arrGame[1].Asteroids[i].CountShots > 5)
              arrGame[1].Asteroids[i].CountShots = 0;
            }



          }

        // leztzen Frame merken
        arrGame[0] = arrGame[1];
        arrGame[1] = new GameStatus();

        // Spiel auf Tastendruck beenden "ESC"
        if (Console.KeyAvailable)
          if (Console.ReadKey(true).Key == ConsoleKey.Escape)
            bExit = true;

        }
      while (!bExit && !Frame.ServerInformation.Contains(Properties.Resources.strBusy)
        && !Frame.ServerInformation.Contains(Properties.Resources.strGameOver));

#if DEBUG
      m_RunOnce = false;
      GC.Collect();
      Console.WriteLine(Frame.ServerInformation);
      Console.WriteLine(Properties.Resources.strWait);
      System.Threading.Thread.Sleep(5000);
#else
      // Aufräumen
      Keys.ClearKeys();
      SendPacket(ref Keys);

      // Statusmeldung
      Console.WriteLine(Frame.ServerInformation);
      Console.WriteLine(Properties.Resources.strContiuneToExit);
      Console.ReadKey();
#endif
      }

    /// <summary>
    /// Winkelbyte synchronisieren
    /// </summary>
    /// <param name="arrGame">The arr game.</param>
    /// <param name="AngleByte">The angle byte.</param>
    /// <param name="bLastTurn2">The b last turn2.</param>
    /// <returns></returns>
    /// ****************************************************************************************************
    /// * Datum: 05.05.2008 22:30
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Winkelbyte synchronisieren 
    /// ****************************************************************************************************
    private byte SyncAngleByte(GameStatus[] arrGame, byte AngleByte, int bLastTurn2)
      {
      if (m_AngleTable[AngleByte].ScreenX != arrGame[0].MyShip.ShipDirectionX
        && m_AngleTable[AngleByte].ScreenY != arrGame[0].MyShip.ShipDirectionY)
        {
        // Linksdrehung synchronisieren
        if (bLastTurn2 == 1)
          for (int z = AngleByte - 20; z <= 255; z++)
            {
            if (z < 0)
              z = 0;
            if (arrGame[1].MyShip.ShipDirectionX == m_AngleTable[z].ScreenX && arrGame[1].MyShip.ShipDirectionY == m_AngleTable[z].ScreenY)
              {
              AngleByte = m_AngleTable[z].AngleByte;
              //Console.WriteLine("Sync {0}", AngleByte);
              break;
              }
            }

        // Rechtsdrehung synchronisieren
        if (bLastTurn2 == 2)
          for (int z = AngleByte + 20; z >= 0; z--)
            {
            if (z > 255)
              z = 255;
            if (arrGame[1].MyShip.ShipDirectionX == m_AngleTable[z].ScreenX && arrGame[1].MyShip.ShipDirectionY == m_AngleTable[z].ScreenY)
              {
              AngleByte = m_AngleTable[z].AngleByte;
              //Console.WriteLine("Sync {0}", AngleByte);
              break;
              }
            }
        }
      return AngleByte;
      }

    /// <summary>
    /// Bilschirm auswerten
    /// </summary>
    /// <param name="Packet">The packet.</param>
    /// <param name="Game">The game.</param>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:24
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: Bilschirm auswerten 
    /// ****************************************************************************************************
    private void InterpretScreen(ref FramePacket Packet, ref GameStatus Game)
      {
      int dx = 0, dy = 0, sf = 0, vx = 0, vy = 0, vz = 0, vs = 0, pc = 1, op = 0;
      int v1x = 0;
      int v1y = 0;
      int shipdetect = 0;
      bool bExit = false;

      Game.Clear();

      if (Packet.ByteVectorRam[1] != 0xe0 && Packet.ByteVectorRam[1] != 0xe2)
        return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

      do
        {
        op = Packet.arrVectorRam[pc] >> 12;

        switch (op)
          {
          case 0xa: // LABS
            vy = Packet.arrVectorRam[pc] & 0x3ff;
            vx = Packet.arrVectorRam[pc + 1] & 0x3ff;
            vs = Packet.arrVectorRam[pc + 1] >> 12;
            break;

          case 0xb: // HALT
            bExit = true;
            break;

          case 0xc: // JSRL
            switch (Packet.arrVectorRam[pc] & 0xfff)
              {
              case 0x8f3:
                Game.Asteroids[Game.CountAsteroids++].Set(vx, vy, 1, vs);
                break;
              case 0x8ff:
                Game.Asteroids[Game.CountAsteroids++].Set(vx, vy, 2, vs);
                break;
              case 0x90d:
                Game.Asteroids[Game.CountAsteroids++].Set(vx, vy, 3, vs);
                break;
              case 0x91a:
                Game.Asteroids[Game.CountAsteroids++].Set(vx, vy, 4, vs);
                break;
              case 0x929:
                Game.IsUfoPresent = true;
                Game.Ufo.CurrentPos.X = vx;
                Game.Ufo.CurrentPos.Y = vy;
                Game.Ufo.UfoSize = vs;
                break;
              }
            break;
          case 0xd: // RTSL
            bExit = true;
            break;

          case 0xe: // JMPL
            /*
            pc = vector_ram[pc] & 0xfff;
            break;
            */
            bExit = true;
            break;

          case 0xf: // SVEC
            /*
            dy = vector_ram[pc] & 0x300;
            if ((vector_ram[pc] & 0x400) != 0)
              dy = -dy;
            dx = (vector_ram[pc] & 3) << 8;
            if ((vector_ram[pc] & 4) != 0)
              dx = -dx;
            sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
            vz = (vector_ram[pc] & 0xf0) >> 4;
            */
            break;

          default:
            dy = Packet.arrVectorRam[pc] & 0x3ff;
            if ((Packet.arrVectorRam[pc] & 0x400) != 0)
              dy = -dy;
            dx = Packet.arrVectorRam[pc + 1] & 0x3ff;
            if ((Packet.arrVectorRam[pc + 1] & 0x400) != 0)
              dx = -dx;
            sf = op;
            vz = Packet.arrVectorRam[pc + 1] >> 12;
            if (dx == 0 && dy == 0 && vz == 15)
              {
              Game.Shots[Game.CountShots++].SetPoint(vx, vy);
              }
            if (op == 6 && vz == 12 && dx != 0 && dy != 0)
              {
              switch (shipdetect)
                {
                case 0:
                  v1x = dx;
                  v1y = dy;
                  ++shipdetect;
                  break;
                case 1:
                  Game.IsShipPresent = true;
                  Game.MyShip.CurrentPos.X = vx;
                  Game.MyShip.CurrentPos.Y = vy;
                  Game.MyShip.ShipDirectionX = v1x - dx;
                  Game.MyShip.ShipDirectionY = v1y - dy;
                  ++shipdetect;
                  break;
                }
              }
            else
              if (shipdetect == 1)
                shipdetect = 0;

            break;
          }

        if (op <= 0xa)
          ++pc;
        if (op != 0xe) // JMPL
          ++pc;
        }
      while (!bExit && pc < 511);

      }

    /// <summary>
    /// UDP-Packet empfangen
    /// </summary>
    /// <param name="Packet">The packet.</param>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:26
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: UDP-Packet empfangen 
    /// ****************************************************************************************************
    private void ReceivePacket(ref FramePacket Packet)
      {
      Packet.RecivedPacket = m_UDPClient.Receive(ref m_IPEndPoint);
      }

    /// <summary>
    /// UDP-Packet senden
    /// </summary>
    /// <param name="Packet">The packet.</param>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 22:27
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung: UDP-Packet senden 
    /// ****************************************************************************************************
    private void SendPacket(ref KeysPacket Packet)
      {
      m_UDPClient.Send(Packet.Frame, Packet.Frame.Length * sizeof(byte));
      }
    }
  }

